--> Pralable
-- USE DB_RH;

WITH
TS AS
(SELECT s.name AS TABLE_SCHEMA, o.name AS TABLE_NAME, i.name AS INDEX_NAME,
        SUM(css.on_disk_size)/1024.0 segment_on_disk_size_KB,
        i.object_id
 FROM   sys.indexes AS i
        INNER JOIN sys.objects AS o
              ON i.object_id = o.object_id
        INNER JOIN sys.schemas AS s
              ON o.schema_id = s.schema_id
        INNER JOIN sys.partitions AS p
              ON i.object_id = p.object_id
        INNER JOIN sys.column_store_segments AS css
              ON css.hobt_id = p.hobt_id
 WHERE  i.type_desc = 'NONCLUSTERED COLUMNSTORE'
 GROUP  BY i.object_id, s.name, o.name, i.name),
TI AS
(SELECT s.name AS TABLE_SCHEMA, o.name AS TABLE_NAME, i.name AS INDEX_NAME,
        SUM(csd.on_disk_size)/1024.0 dictionary_on_disk_size_KB,
        i.object_id
 FROM   sys.indexes AS i
        INNER JOIN sys.objects AS o
              ON i.object_id = o.object_id
        INNER JOIN sys.schemas AS s
              ON o.schema_id = s.schema_id
        INNER JOIN sys.partitions AS p
              ON i.object_id = p.object_id
        INNER JOIN sys.column_store_dictionaries AS csd
              ON csd.hobt_id = p.hobt_id
 WHERE  i.type_desc = 'NONCLUSTERED COLUMNSTORE'
 GROUP  BY i.object_id, s.name , o.name, i.name)
SELECT TS.TABLE_SCHEMA, TS.TABLE_NAME, TS.INDEX_NAME,
       segment_on_disk_size_KB, dictionary_on_disk_size_KB,
       dictionary_on_disk_size_KB + segment_on_disk_size_KB AS total_on_disk_size_KB
FROM   TS
       INNER JOIN TI
             ON TS.object_id = TI.object_id;
